/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.drm;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;
import jogamp.nativewindow.drm.drmModeModeInfo;

public class drmModeCrtc {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] drmModeCrtc_size = new int[]{100, 100, 100, 100, 100, 100, 100, 100, 100, 100};
    private static final int[] crtc_id_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] buffer_id_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] x_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] y_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final int[] width_offset = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] height_offset = new int[]{20, 20, 20, 20, 20, 20, 20, 20, 20, 20};
    private static final int[] mode_valid_offset = new int[]{24, 24, 24, 24, 24, 24, 24, 24, 24, 24};
    private static final int[] mode_offset = new int[]{28, 28, 28, 28, 28, 28, 28, 28, 28, 28};
    private static final int[] mode_size = new int[]{68, 68, 68, 68, 68, 68, 68, 68, 68, 68};
    private static final int[] gamma_size_offset = new int[]{96, 96, 96, 96, 96, 96, 96, 96, 96, 96};

    public static int size() {
        return drmModeCrtc_size[mdIdx];
    }

    public static drmModeCrtc create() {
        return drmModeCrtc.create(Buffers.newDirectByteBuffer(drmModeCrtc.size()));
    }

    public static drmModeCrtc create(ByteBuffer byteBuffer) {
        return new drmModeCrtc(byteBuffer);
    }

    drmModeCrtc(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[drmModeCrtc.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public drmModeCrtc setCrtc_id(int n) {
        this.accessor.setIntAt(crtc_id_offset[mdIdx], n);
        return this;
    }

    public int getCrtc_id() {
        return this.accessor.getIntAt(crtc_id_offset[mdIdx]);
    }

    public drmModeCrtc setBuffer_id(int n) {
        this.accessor.setIntAt(buffer_id_offset[mdIdx], n);
        return this;
    }

    public int getBuffer_id() {
        return this.accessor.getIntAt(buffer_id_offset[mdIdx]);
    }

    public drmModeCrtc setX(int n) {
        this.accessor.setIntAt(x_offset[mdIdx], n);
        return this;
    }

    public int getX() {
        return this.accessor.getIntAt(x_offset[mdIdx]);
    }

    public drmModeCrtc setY(int n) {
        this.accessor.setIntAt(y_offset[mdIdx], n);
        return this;
    }

    public int getY() {
        return this.accessor.getIntAt(y_offset[mdIdx]);
    }

    public drmModeCrtc setWidth(int n) {
        this.accessor.setIntAt(width_offset[mdIdx], n);
        return this;
    }

    public int getWidth() {
        return this.accessor.getIntAt(width_offset[mdIdx]);
    }

    public drmModeCrtc setHeight(int n) {
        this.accessor.setIntAt(height_offset[mdIdx], n);
        return this;
    }

    public int getHeight() {
        return this.accessor.getIntAt(height_offset[mdIdx]);
    }

    public drmModeCrtc setMode_valid(int n) {
        this.accessor.setIntAt(mode_valid_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getMode_valid() {
        return this.accessor.getIntAt(mode_valid_offset[mdIdx], this.md.intSizeInBytes());
    }

    public drmModeModeInfo getMode() {
        return drmModeModeInfo.create(this.accessor.slice(mode_offset[mdIdx], mode_size[mdIdx]));
    }

    public drmModeCrtc setGamma_size(int n) {
        this.accessor.setIntAt(gamma_size_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getGamma_size() {
        return this.accessor.getIntAt(gamma_size_offset[mdIdx], this.md.intSizeInBytes());
    }
}

