/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesFilter;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.windows.WindowsGraphicsDevice;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.nativewindow.windows.PIXELFORMATDESCRIPTOR;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLGraphicsConfigurationFactory;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.windows.wgl.WGLGLCapabilities;
import jogamp.opengl.windows.wgl.WGLUtil;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;

public class WindowsWGLGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactory {
    static VisualIDHolder.VIDComparator PfdIDComparator = new VisualIDHolder.VIDComparator(VisualIDHolder.VIDType.WIN32_PFD);

    static void registerFactory() {
        GraphicsConfigurationFactory.registerFactory(WindowsGraphicsDevice.class, GLCapabilitiesImmutable.class, new WindowsWGLGraphicsConfigurationFactory());
    }

    private WindowsWGLGraphicsConfigurationFactory() {
    }

    @Override
    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - chosen");
        }
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - requested");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        return WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)capabilitiesImmutable, (GLCapabilitiesImmutable)capabilitiesImmutable2, (GLCapabilitiesChooser)capabilitiesChooser, abstractGraphicsScreen);
    }

    static WindowsWGLGraphicsConfiguration createDefaultGraphicsConfiguration(GLCapabilitiesImmutable gLCapabilitiesImmutable, AbstractGraphicsScreen abstractGraphicsScreen) {
        return WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, null, abstractGraphicsScreen);
    }

    static WindowsWGLGraphicsConfiguration chooseGraphicsConfigurationStatic(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        if (null == abstractGraphicsScreen) {
            abstractGraphicsScreen = DefaultGraphicsScreen.createDefault(".windows");
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixGLCapabilities(gLCapabilitiesImmutable, GLDrawableFactory.getDesktopFactory(), abstractGraphicsDevice);
        return new WindowsWGLGraphicsConfiguration(abstractGraphicsScreen, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<GLCapabilitiesImmutable> getAvailableCapabilities(WindowsWGLDrawableFactory windowsWGLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        GLContextImpl gLContextImpl;
        WindowsWGLDrawableFactory.SharedResource sharedResource = windowsWGLDrawableFactory.getOrCreateSharedResourceImpl(abstractGraphicsDevice);
        if (null == sharedResource) {
            throw new GLException("Shared resource for device n/a: " + abstractGraphicsDevice);
        }
        GLDrawableImpl gLDrawableImpl = sharedResource.getDrawable();
        GLProfile gLProfile = GLProfile.getDefault(abstractGraphicsDevice);
        List<GLCapabilitiesImmutable> list = null;
        if (windowsWGLDrawableFactory.hasRendererQuirk(abstractGraphicsDevice, null, 9)) {
            gLContextImpl = sharedResource.getContext();
            if (0 == ((GLContext)gLContextImpl).makeCurrent()) {
                throw new GLException("Could not make Shared Context current: " + abstractGraphicsDevice);
            }
        } else {
            gLContextImpl = null;
            gLDrawableImpl.lockSurface();
        }
        try {
            long l = gLDrawableImpl.getHandle();
            if (0L == l) {
                throw new GLException("Error: HDC is null");
            }
            if (sharedResource.hasARBPixelFormat()) {
                list = WindowsWGLGraphicsConfigurationFactory.getAvailableGLCapabilitiesARB(sharedResource, sharedResource.getDevice(), gLProfile, l);
            }
            boolean bl = null != list && !list.isEmpty();
            List<GLCapabilitiesImmutable> list2 = WindowsWGLGraphicsConfigurationFactory.getAvailableGLCapabilitiesGDI(abstractGraphicsDevice, gLProfile, l, bl);
            if (!bl) {
                list = list2;
            } else {
                list.addAll(list2);
            }
        }
        finally {
            if (null != gLContextImpl) {
                ((GLContext)gLContextImpl).release();
            } else {
                gLDrawableImpl.unlockSurface();
            }
        }
        if (null != list && list.size() > 1) {
            Collections.sort(list, PfdIDComparator);
        }
        return list;
    }

    private static List<GLCapabilitiesImmutable> getAvailableGLCapabilitiesARB(WindowsWGLDrawableFactory.SharedResource sharedResource, AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, long l) {
        int n = WindowsWGLGraphicsConfiguration.wglARBPFDIDCount((WindowsWGLContext)sharedResource.getContext(), l);
        int[] nArray = WindowsWGLGraphicsConfiguration.wglAllARBPFDIDs(n);
        return WindowsWGLGraphicsConfiguration.wglARBPFIDs2GLCapabilities(sharedResource, abstractGraphicsDevice, gLProfile, l, nArray, 13, false);
    }

    private static List<GLCapabilitiesImmutable> getAvailableGLCapabilitiesGDI(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, long l, boolean bl) {
        int[] nArray = WindowsWGLGraphicsConfiguration.wglAllGDIPFIDs(l);
        int n = nArray.length;
        ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>(n);
        for (int i = 0; i < n; ++i) {
            WGLGLCapabilities wGLGLCapabilities = WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(abstractGraphicsDevice, gLProfile, l, nArray[i], bl ? 2 : 15);
            if (null == wGLGLCapabilities) continue;
            arrayList.add(wGLGLCapabilities);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateGraphicsConfiguration(CapabilitiesChooser capabilitiesChooser, GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, int[] nArray) {
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        if (gLDrawableFactory == null) {
            throw new IllegalArgumentException("GLDrawableFactory is null");
        }
        if (nativeSurface == null) {
            throw new IllegalArgumentException("NativeSurface is null");
        }
        if (1 >= nativeSurface.lockSurface()) {
            throw new GLException("Surface not ready (lockSurface)");
        }
        try {
            long l = nativeSurface.getSurfaceHandle();
            if (0L == l) {
                if (!(nativeSurface instanceof ProxySurface) || !((ProxySurface)nativeSurface).containsUpstreamOptionBits(512)) {
                    throw new GLException(String.format("non-surfaceless drawable has zero-handle (HDC): %s", nativeSurface.toString()));
                }
                return;
            }
            WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
            if (!windowsWGLGraphicsConfiguration.isExternal()) {
                if (!windowsWGLGraphicsConfiguration.isDetermined()) {
                    WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfiguration(windowsWGLGraphicsConfiguration, capabilitiesChooser, gLDrawableFactory, l, false, nArray);
                } else {
                    int n = -1;
                    boolean bl = false;
                    n = WGLUtil.GetPixelFormat(l);
                    if (1 > n) {
                        if (!WGLUtil.SetPixelFormat(l, windowsWGLGraphicsConfiguration.getPixelFormatID(), windowsWGLGraphicsConfiguration.getPixelFormat())) {
                            throw new GLException("Unable to set pixel format " + windowsWGLGraphicsConfiguration.getPixelFormatID() + " for device context " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ": error code " + GDI.GetLastError());
                        }
                        bl = true;
                    }
                    if (DEBUG) {
                        System.err.println("setPixelFormat (post): hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ", " + n + " -> " + windowsWGLGraphicsConfiguration.getPixelFormatID() + ", set: " + bl);
                    }
                }
            }
        }
        finally {
            nativeSurface.unlockSurface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void preselectGraphicsConfiguration(CapabilitiesChooser capabilitiesChooser, GLDrawableFactory gLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice, WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration, int[] nArray) {
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        if (gLDrawableFactory == null) {
            throw new IllegalArgumentException("GLDrawableFactory is null");
        }
        if (windowsWGLGraphicsConfiguration == null) {
            throw new IllegalArgumentException("WindowsWGLGraphicsConfiguration is null");
        }
        if (!(gLDrawableFactory instanceof WindowsWGLDrawableFactory)) {
            throw new GLException("GLDrawableFactory is not a WindowsWGLDrawableFactory, but: " + gLDrawableFactory.getClass().getSimpleName());
        }
        WindowsWGLDrawableFactory windowsWGLDrawableFactory = (WindowsWGLDrawableFactory)gLDrawableFactory;
        WindowsWGLDrawable windowsWGLDrawable = windowsWGLDrawableFactory.getOrCreateSharedDrawable(abstractGraphicsDevice);
        if (null == windowsWGLDrawable) {
            throw new IllegalArgumentException("Shared Drawable is null");
        }
        if (1 >= windowsWGLDrawable.lockSurface()) {
            throw new GLException("Shared Surface not ready (lockSurface): " + abstractGraphicsDevice + " -> " + windowsWGLDrawable);
        }
        try {
            long l = windowsWGLDrawable.getHandle();
            if (0L == l) {
                throw new GLException("Error: HDC is null");
            }
            WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfiguration(windowsWGLGraphicsConfiguration, capabilitiesChooser, windowsWGLDrawableFactory, l, true, nArray);
        }
        finally {
            windowsWGLDrawable.unlockSurface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateGraphicsConfiguration(WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration, CapabilitiesChooser capabilitiesChooser, GLDrawableFactory gLDrawableFactory, long l, boolean bl, int[] nArray) {
        GLContextImpl gLContextImpl;
        if (DEBUG) {
            if (bl) {
                System.err.println("updateGraphicsConfiguration(using shared): hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l));
            } else {
                System.err.println("updateGraphicsConfiguration(using target): hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l));
            }
            System.err.println("user chosen caps " + windowsWGLGraphicsConfiguration.getChosenCapabilities());
        }
        AbstractGraphicsDevice abstractGraphicsDevice = windowsWGLGraphicsConfiguration.getScreen().getDevice();
        WindowsWGLDrawableFactory.SharedResource sharedResource = ((WindowsWGLDrawableFactory)gLDrawableFactory).getOrCreateSharedResourceImpl(abstractGraphicsDevice);
        if (gLDrawableFactory.hasRendererQuirk(abstractGraphicsDevice, null, 9)) {
            gLContextImpl = sharedResource.getContext();
            if (0 == ((GLContext)gLContextImpl).makeCurrent()) {
                throw new GLException("Could not make Shared Context current: " + abstractGraphicsDevice);
            }
        } else {
            gLContextImpl = null;
        }
        try {
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getChosenCapabilities();
            boolean bl2 = false;
            if (gLCapabilitiesImmutable.getHardwareAccelerated() && !gLCapabilitiesImmutable.isBitmap()) {
                bl2 = WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfigurationARB((WindowsWGLDrawableFactory)gLDrawableFactory, windowsWGLGraphicsConfiguration, capabilitiesChooser, l, bl, nArray);
            }
            if (!bl2) {
                WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfigurationGDI(windowsWGLGraphicsConfiguration, capabilitiesChooser, l, bl, nArray);
            }
        }
        finally {
            if (null != gLContextImpl) {
                ((GLContext)gLContextImpl).release();
            }
        }
    }

    private static boolean updateGraphicsConfigurationARB(WindowsWGLDrawableFactory windowsWGLDrawableFactory, WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration, CapabilitiesChooser capabilitiesChooser, long l, boolean bl, int[] nArray) {
        int n;
        AbstractGraphicsDevice abstractGraphicsDevice = windowsWGLGraphicsConfiguration.getScreen().getDevice();
        WindowsWGLDrawableFactory.SharedResource sharedResource = windowsWGLDrawableFactory.getOrCreateSharedResourceImpl(abstractGraphicsDevice);
        if (null == sharedResource) {
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationARB: SharedResource is null: " + abstractGraphicsDevice);
            }
            return false;
        }
        if (!sharedResource.hasARBPixelFormat()) {
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationARB: WGL_ARB_pixel_format not available");
            }
            return false;
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getChosenCapabilities();
        boolean bl2 = gLCapabilitiesImmutable.isBackgroundOpaque() && GDIUtil.DwmIsCompositionEnabled();
        int n2 = GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits(gLCapabilitiesImmutable) & 0xFFFFFFFD;
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        GLRendererQuirks gLRendererQuirks = windowsWGLDrawableFactory.getRendererQuirks(abstractGraphicsDevice, gLProfile);
        boolean bl3 = gLCapabilitiesImmutable.isBitmap() || gLCapabilitiesImmutable.isPBuffer();
        boolean bl4 = GLRendererQuirks.exist(gLRendererQuirks, 24) || bl3 && GLRendererQuirks.exist(gLRendererQuirks, 25);
        boolean bl5 = !bl4 && gLCapabilitiesImmutable.isBackgroundOpaque();
        int n3 = WindowsWGLGraphicsConfiguration.wglARBPFDIDCount((WindowsWGLContext)sharedResource.getContext(), l);
        if (DEBUG) {
            System.err.println("updateGraphicsConfigurationARB: hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ", pfdIDCount(hdc) " + n3 + ", capsChosen " + gLCapabilitiesImmutable + ", " + GLGraphicsConfigurationUtil.winAttributeBits2String(null, n2).toString());
            System.err.println("\tisOpaque " + bl2 + " (translucency requested: " + !gLCapabilitiesImmutable.isBackgroundOpaque() + ", compositioning enabled: " + GDIUtil.DwmIsCompositionEnabled() + ")");
            int n4 = null != nArray ? nArray.length : -1;
            System.err.println("\textHDC " + bl + ", chooser " + (null != capabilitiesChooser) + ", pformatsNum " + n4);
        }
        if (0 >= n3) {
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationARB: failed due to 0 pfdIDs for hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + " - hdc incompatible w/ ARB ext.");
            }
            return false;
        }
        WGLGLCapabilities wGLGLCapabilities = null;
        boolean bl6 = false;
        int n5 = n = bl ? -1 : WGLUtil.GetPixelFormat(l);
        if (1 <= n) {
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationARB: Pixel format already chosen for HDC: " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ", pixelformat " + n);
            }
            bl6 = true;
            wGLGLCapabilities = WindowsWGLGraphicsConfiguration.wglARBPFID2GLCapabilities(sharedResource, abstractGraphicsDevice, gLProfile, l, n, n2);
            wGLGLCapabilities = (WGLGLCapabilities)GLGraphicsConfigurationUtil.fixOpaqueGLCapabilities(wGLGLCapabilities, bl2);
        } else {
            boolean bl7;
            Object object;
            int n6;
            int n7 = -1;
            if (null == nArray) {
                IntBuffer intBuffer = Buffers.newDirectIntBuffer(512);
                nArray = WindowsWGLGraphicsConfiguration.wglChoosePixelFormatARB(sharedResource, abstractGraphicsDevice, gLCapabilitiesImmutable, l, intBuffer, n6 = 8231, (FloatBuffer)(object = Buffers.newDirectFloatBuffer(1)));
                if (null == nArray) {
                    n6 = 8230;
                    nArray = WindowsWGLGraphicsConfiguration.wglChoosePixelFormatARB(sharedResource, abstractGraphicsDevice, gLCapabilitiesImmutable, l, intBuffer, n6, (FloatBuffer)object);
                }
                if (null == nArray) {
                    n6 = -1;
                    nArray = WindowsWGLGraphicsConfiguration.wglChoosePixelFormatARB(sharedResource, abstractGraphicsDevice, gLCapabilitiesImmutable, l, intBuffer, n6, (FloatBuffer)object);
                }
                if (null != nArray) {
                    if (bl5) {
                        n7 = 0;
                    }
                } else {
                    if (DEBUG) {
                        System.err.println("updateGraphicsConfigurationARB: wglChoosePixelFormatARB failed with: " + gLCapabilitiesImmutable);
                    }
                    nArray = WindowsWGLGraphicsConfiguration.wglAllARBPFDIDs(n3);
                    if (DEBUG) {
                        int n8 = null != nArray ? nArray.length : 0;
                        System.err.println("updateGraphicsConfigurationARB: NumFormats (wglAllARBPFIDs) " + n8);
                    }
                }
                if (null == nArray) {
                    if (DEBUG) {
                        System.err.println("updateGraphicsConfigurationARB: failed, return false");
                        ExceptionUtils.dumpStack(System.err);
                    }
                    return false;
                }
            }
            if (null == (object = WindowsWGLGraphicsConfiguration.wglARBPFIDs2GLCapabilities(sharedResource, abstractGraphicsDevice, gLProfile, l, nArray, n2, bl7 = 0 <= n7 && null == capabilitiesChooser && bl5)) || 0 == ((ArrayList)object).size()) {
                if (DEBUG) {
                    System.err.println("updateGraphicsConfigurationARB: wglARBPFIDs2GLCapabilities failed with " + nArray.length + " pfd ids");
                    ExceptionUtils.dumpStack(System.err);
                }
                return false;
            }
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationARB: " + nArray.length + " pfd ids, skipCapsChooser " + bl7 + ", " + GLGraphicsConfigurationUtil.winAttributeBits2String(null, n2).toString() + ", " + ((ArrayList)object).size() + " glcaps");
                if (0 <= n7) {
                    System.err.println("updateGraphicsConfigurationARB: Used wglChoosePixelFormatARB to recommend pixel format " + nArray[n7] + ", idx " + n7 + ", " + ((ArrayList)object).get(n7));
                }
            }
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationARB: got configs: " + ((ArrayList)object).size());
                for (n6 = 0; n6 < ((ArrayList)object).size(); ++n6) {
                    System.err.println(n6 + ": " + ((ArrayList)object).get(n6));
                }
            }
            if (!bl7 && bl3 && GLRendererQuirks.exist(gLRendererQuirks, 25)) {
                CapabilitiesFilter.removeMoreColorComps(object, 8);
                if (DEBUG) {
                    System.err.println("updateGraphicsConfigurationARB: filtered configs: " + ((ArrayList)object).size());
                    for (n6 = 0; n6 < ((ArrayList)object).size(); ++n6) {
                        System.err.println(n6 + ": " + ((ArrayList)object).get(n6));
                    }
                }
            }
            if (0 > (n6 = bl7 ? n7 : WindowsWGLGraphicsConfigurationFactory.chooseCapabilities(capabilitiesChooser, gLCapabilitiesImmutable, (List<? extends CapabilitiesImmutable>)object, n7))) {
                if (DEBUG) {
                    ExceptionUtils.dumpStack(System.err);
                }
                return false;
            }
            wGLGLCapabilities = (WGLGLCapabilities)((ArrayList)object).get(n6);
            if (null == wGLGLCapabilities) {
                throw new GLException("Null Capabilities with  chosen pfdID: native recommended " + (n7 + 1) + " chosen idx " + n6 + ", skipCapsChooser " + bl7);
            }
            wGLGLCapabilities = (WGLGLCapabilities)GLGraphicsConfigurationUtil.fixOpaqueGLCapabilities(wGLGLCapabilities, bl2);
            if (DEBUG) {
                System.err.println("chosen pfdID (ARB): native recommended " + (n7 + 1) + " chosen " + wGLGLCapabilities + ", skipCapsChooser " + bl7);
            }
        }
        if (!bl && !bl6) {
            windowsWGLGraphicsConfiguration.setPixelFormat(l, wGLGLCapabilities);
        } else {
            windowsWGLGraphicsConfiguration.setCapsPFD(wGLGLCapabilities);
        }
        return true;
    }

    private static boolean updateGraphicsConfigurationGDI(WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration, CapabilitiesChooser capabilitiesChooser, long l, boolean bl, int[] nArray) {
        int n;
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isOnscreen() && gLCapabilitiesImmutable.isPBuffer()) {
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationGDI: no pbuffer supported on GDI: " + gLCapabilitiesImmutable);
            }
            return false;
        }
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        int n2 = GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits(gLCapabilitiesImmutable);
        if (DEBUG) {
            System.err.println("updateGraphicsConfigurationGDI: hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ", capsChosen " + gLCapabilitiesImmutable + ", " + GLGraphicsConfigurationUtil.winAttributeBits2String(null, n2).toString());
            int n3 = null != nArray ? nArray.length : -1;
            System.err.println("\textHDC " + bl + ", chooser " + (null != capabilitiesChooser) + ", pformatsNum " + n3);
        }
        AbstractGraphicsDevice abstractGraphicsDevice = windowsWGLGraphicsConfiguration.getScreen().getDevice();
        WGLGLCapabilities wGLGLCapabilities = null;
        boolean bl2 = false;
        int n4 = n = bl ? -1 : WGLUtil.GetPixelFormat(l);
        if (1 <= n) {
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationGDI: NOTE: pixel format already chosen for HDC: " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ", pixelformat " + n);
            }
            bl2 = true;
            wGLGLCapabilities = WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(abstractGraphicsDevice, gLProfile, l, n, n2);
            if (null == wGLGLCapabilities) {
                throw new GLException("Could not map PFD2GLCaps w/ already chosen pfdID " + n);
            }
        } else {
            WGLGLCapabilities wGLGLCapabilities2;
            boolean bl3;
            WGLGLCapabilities wGLGLCapabilities3;
            int n5;
            int n6;
            boolean bl4;
            boolean bl5 = bl4 = null != nArray;
            if (!bl4) {
                nArray = WindowsWGLGraphicsConfiguration.wglAllGDIPFIDs(l);
            }
            ArrayList<WGLGLCapabilities> arrayList = new ArrayList<WGLGLCapabilities>();
            PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor();
            pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.GLCapabilities2PFD(gLCapabilitiesImmutable, pIXELFORMATDESCRIPTOR);
            int n7 = WGLUtil.ChoosePixelFormat(l, pIXELFORMATDESCRIPTOR);
            int n8 = -1;
            if (1 <= n7) {
                n6 = null == capabilitiesChooser && gLCapabilitiesImmutable.isBackgroundOpaque() ? 1 : 0;
                for (n5 = nArray.length - 1; 0 <= n5 && n7 != nArray[n5]; --n5) {
                }
                if (0 <= n5) {
                    if (n6 != 0) {
                        wGLGLCapabilities3 = WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(abstractGraphicsDevice, gLProfile, l, n7, n2);
                        if (null != wGLGLCapabilities3) {
                            arrayList.add(wGLGLCapabilities3);
                            n8 = 0;
                            bl3 = true;
                        } else {
                            bl3 = false;
                        }
                    } else {
                        bl3 = false;
                    }
                    if (DEBUG) {
                        System.err.println("Chosen PFDID " + n7 + " (idx " + n5 + ") -> recommendedIndex " + n8 + ", skipCapsChooser " + bl3);
                    }
                } else {
                    if (DEBUG) {
                        wGLGLCapabilities3 = WindowsWGLGraphicsConfiguration.PFD2GLCapabilitiesNoCheck(abstractGraphicsDevice, gLProfile, pIXELFORMATDESCRIPTOR, n7);
                        wGLGLCapabilities2 = WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(abstractGraphicsDevice, gLProfile, l, n7, n2);
                        System.err.println("Chosen PFDID " + n7 + " (idx " + n5 + "), but not found in available caps (use given pfdIDs " + bl4 + ", reqPFDCaps " + wGLGLCapabilities3 + ", chosenCaps: " + wGLGLCapabilities2);
                    }
                    n7 = 0;
                    bl3 = false;
                }
            } else {
                bl3 = false;
            }
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationGDI: ChoosePixelFormat(HDC " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ") = pfdID " + n7 + ", skipCapsChooser " + bl3 + ", idx " + n8 + " (LastError: " + GDI.GetLastError() + ")");
            }
            if (!bl3) {
                for (n6 = 0; n6 < nArray.length; ++n6) {
                    n5 = nArray[n6];
                    wGLGLCapabilities3 = WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(abstractGraphicsDevice, gLProfile, l, n5, n2);
                    if (null != wGLGLCapabilities3) {
                        arrayList.add(wGLGLCapabilities3);
                        if (!DEBUG) continue;
                        int n9 = arrayList.size() - 1;
                        System.err.println("updateGraphicsConfigurationGDI: availableCaps[" + n6 + " -> " + n9 + "]: " + wGLGLCapabilities3);
                        continue;
                    }
                    if (!DEBUG) continue;
                    wGLGLCapabilities2 = WindowsWGLGraphicsConfiguration.PFD2GLCapabilitiesNoCheck(abstractGraphicsDevice, gLProfile, l, nArray[n6]);
                    System.err.println("updateGraphicsConfigurationGDI: availableCaps[" + n6 + " -> skip]: pfdID " + nArray[n6] + ", " + wGLGLCapabilities2);
                }
                if (1 <= n7 && 0 > n8) {
                    for (n8 = arrayList.size() - 1; 0 <= n8 && n7 != ((WGLGLCapabilities)arrayList.get(n8)).getPFDID(); --n8) {
                    }
                }
            }
            if (0 > (n6 = bl3 ? n8 : WindowsWGLGraphicsConfigurationFactory.chooseCapabilities(capabilitiesChooser, gLCapabilitiesImmutable, arrayList, n8))) {
                if (DEBUG) {
                    System.err.println("updateGraphicsConfigurationGDI: failed, return false");
                    ExceptionUtils.dumpStack(System.err);
                }
                return false;
            }
            wGLGLCapabilities = (WGLGLCapabilities)arrayList.get(n6);
            if (DEBUG) {
                System.err.println("chosen pfdID (GDI): recommendedIndex " + n8 + " -> chosenIndex " + n6 + ", skipCapsChooser " + bl3 + ", caps " + wGLGLCapabilities + " (" + WGLGLCapabilities.PFD2String(wGLGLCapabilities.getPFD(), wGLGLCapabilities.getPFDID()) + ")");
            }
        }
        if (!bl && !bl2) {
            windowsWGLGraphicsConfiguration.setPixelFormat(l, wGLGLCapabilities);
        } else {
            windowsWGLGraphicsConfiguration.setCapsPFD(wGLGLCapabilities);
        }
        return true;
    }
}

