/*
 * Decompiled with CFR 0.152.
 */
package me.friwi.jcefmaven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.friwi.jcefmaven.CefBuildInfo;
import me.friwi.jcefmaven.CefInitializationException;
import me.friwi.jcefmaven.EnumPlatform;
import me.friwi.jcefmaven.EnumProgress;
import me.friwi.jcefmaven.IProgressHandler;
import me.friwi.jcefmaven.MavenCefAppHandlerAdapter;
import me.friwi.jcefmaven.UnsupportedPlatformException;
import me.friwi.jcefmaven.impl.progress.ConsoleProgressHandler;
import me.friwi.jcefmaven.impl.step.check.CefInstallationChecker;
import me.friwi.jcefmaven.impl.step.extract.TarGzExtractor;
import me.friwi.jcefmaven.impl.step.fetch.PackageClasspathStreamer;
import me.friwi.jcefmaven.impl.step.fetch.PackageDownloader;
import me.friwi.jcefmaven.impl.step.init.CefInitializer;
import me.friwi.jcefmaven.impl.util.FileUtils;
import me.friwi.jcefmaven.impl.util.macos.UnquarantineUtil;
import org.cef.CefApp;
import org.cef.CefSettings;

public class CefAppBuilder {
    private static final File DEFAULT_INSTALL_DIR = new File("jcef-bundle");
    private static final IProgressHandler DEFAULT_PROGRESS_HANDLER = new ConsoleProgressHandler();
    private static final List<String> DEFAULT_JCEF_ARGS = new LinkedList<String>();
    private static final CefSettings DEFAULT_CEF_SETTINGS = new CefSettings();
    private final Object lock = new Object();
    private final List<String> jcefArgs;
    private final CefSettings cefSettings;
    private File installDir = DEFAULT_INSTALL_DIR;
    private IProgressHandler progressHandler = DEFAULT_PROGRESS_HANDLER;
    private CefApp instance = null;
    private boolean building = false;
    private boolean installed = false;
    private final Set<String> mirrors;

    public CefAppBuilder() {
        this.jcefArgs = new LinkedList<String>();
        this.jcefArgs.addAll(DEFAULT_JCEF_ARGS);
        this.cefSettings = DEFAULT_CEF_SETTINGS.clone();
        this.mirrors = new HashSet<String>();
        this.mirrors.add("https://github.com/jcefmaven/jcefmaven/releases/download/{mvn_version}/jcef-natives-{platform}-{tag}.jar");
        this.mirrors.add("https://repo.maven.apache.org/maven2/me/friwi/jcef-natives-{platform}/{tag}/jcef-natives-{platform}-{tag}.jar");
    }

    public void setInstallDir(File installDir) {
        Objects.requireNonNull(installDir, "installDir cannot be null");
        this.installDir = installDir;
    }

    public void setProgressHandler(IProgressHandler progressHandler) {
        Objects.requireNonNull(progressHandler, "progressHandler cannot be null");
        this.progressHandler = progressHandler;
    }

    public List<String> getJcefArgs() {
        return this.jcefArgs;
    }

    public void addJcefArgs(String ... args) {
        Objects.requireNonNull(args, "args cannot be null");
        this.jcefArgs.addAll(Arrays.asList(args));
    }

    public CefSettings getCefSettings() {
        return this.cefSettings;
    }

    public void setAppHandler(MavenCefAppHandlerAdapter handlerAdapter) {
        CefApp.addAppHandler(handlerAdapter);
    }

    public Collection<String> getMirrors() {
        return new HashSet<String>(this.mirrors);
    }

    public void setMirrors(Collection<String> mirrors) {
        Objects.requireNonNull(mirrors, "mirrors can not be null");
        this.mirrors.clear();
        this.mirrors.addAll(mirrors);
    }

    public void setSkipInstallation(boolean skipInstallation) {
        this.installed = skipInstallation;
    }

    public boolean getSkipInstallation() {
        return this.installed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CefAppBuilder install() throws IOException, UnsupportedPlatformException {
        if (this.installed) {
            return this;
        }
        this.progressHandler.handleProgress(EnumProgress.LOCATING, -1.0f);
        boolean installOk = CefInstallationChecker.checkInstallation(this.installDir);
        if (!installOk) {
            FileUtils.deleteDir(this.installDir);
            if (!this.installDir.mkdirs()) {
                throw new IOException("Could not create installation directory");
            }
            try (InputStream nativesIn = PackageClasspathStreamer.streamNatives(CefBuildInfo.fromClasspath(), EnumPlatform.getCurrentPlatform());){
                boolean downloading = false;
                if (nativesIn == null) {
                    ZipEntry entry;
                    this.progressHandler.handleProgress(EnumProgress.DOWNLOADING, -1.0f);
                    downloading = true;
                    File download = new File(this.installDir, "download.zip.temp");
                    PackageDownloader.downloadNatives(CefBuildInfo.fromClasspath(), EnumPlatform.getCurrentPlatform(), download, f -> this.progressHandler.handleProgress(EnumProgress.DOWNLOADING, f.floatValue()), this.mirrors);
                    nativesIn = new ZipInputStream(new FileInputStream(download));
                    boolean found = false;
                    while ((entry = ((ZipInputStream)nativesIn).getNextEntry()) != null) {
                        if (!entry.getName().endsWith(".tar.gz")) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new IOException("Downloaded artifact did not contain a .tar.gz archive");
                    }
                }
                this.progressHandler.handleProgress(EnumProgress.EXTRACTING, -1.0f);
                TarGzExtractor.extractTarGZ(this.installDir, nativesIn);
                if (downloading && !new File(this.installDir, "download.zip.temp").delete()) {
                    throw new IOException("Could not remove downloaded temp file");
                }
            }
            this.progressHandler.handleProgress(EnumProgress.INSTALL, -1.0f);
            if (EnumPlatform.getCurrentPlatform().getOs().isMacOSX()) {
                UnquarantineUtil.unquarantine(this.installDir);
            }
            if (!new File(this.installDir, "install.lock").createNewFile()) {
                throw new IOException("Could not create install.lock to complete installation");
            }
        }
        this.installed = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CefApp build() throws IOException, UnsupportedPlatformException, InterruptedException, CefInitializationException {
        if (this.instance != null) {
            return this.instance;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.building) {
                if (this.instance == null) {
                    this.lock.wait();
                }
                return this.instance;
            }
            this.building = true;
        }
        this.install();
        this.progressHandler.handleProgress(EnumProgress.INITIALIZING, -1.0f);
        object = this.lock;
        synchronized (object) {
            this.instance = CefInitializer.initialize(this.installDir, this.jcefArgs, this.cefSettings);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.instance.dispose()));
            this.progressHandler.handleProgress(EnumProgress.INITIALIZED, -1.0f);
            this.lock.notifyAll();
        }
        return this.instance;
    }
}

