/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.network.CefRequest;
import org.example.KillJavaProcess;
import org.example.Main;
import org.example.MainFrame;
import org.json.JSONObject;

public class CustomRequestHandler
extends CefRequestHandlerAdapter {
    @Override
    public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
        String url = request.getURL();
        System.out.println("Navigating to: " + url);
        if (this.containsQueryParameter(url, "id_token").length() > 0) {
            String idToken = CustomRequestHandler.extractIdTokenFromUrl(url);
            String sessionId = this.getSessionId(idToken);
            this.writeAccountsToTxt(sessionId);
            System.out.println("The URL contains the specified id_token query parameter.");
            KillJavaProcess.kill();
        } else if (this.containsQueryParameter(url, "code").length() > 0) {
            String code = CustomRequestHandler.extractCodeFromUrl(url);
            this.getToken(code);
            System.out.println("The URL contains the specified code query parameter.");
        }
        System.out.println("The URL does not contain the specified query parameter.");
        return super.onBeforeBrowse(browser, frame, request, user_gesture, is_redirect);
    }

    private void getToken(String code) {
        try {
            String postData = "grant_type=authorization_code&client_id=com_jagex_auth_desktop_launcher&code=" + code + "&code_verifier=" + Main.codeVerifier + "&redirect_uri=https://secure.runescape.com/m=weblogin/launcher-redirect";
            URL obj = new URL("https://account.jagex.com/oauth2/token");
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setDoOutput(true);
            try (OutputStream os = con.getOutputStream();){
                byte[] input = postData.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = con.getResponseCode();
            System.out.println("POST Response Code :: " + responseCode);
            if (responseCode == 200) {
                String response = CustomRequestHandler.readResponse(con);
                System.out.println("Response: " + response);
                this.getIdToken(response);
            } else {
                System.out.println("POST request failed.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getIdToken(String response) {
        JSONObject jsonResponse = new JSONObject(response);
        String jwt = jsonResponse.getString("id_token");
        String nonce = CustomRequestHandler.generateNonce(48);
        String url = "https://account.jagex.com/oauth2/auth?id_token_hint=" + jwt + "&nonce=" + nonce + "&prompt=consent&redirect_uri=http%3A%2F%2Flocalhost&response_type=id_token+code&state=" + Main.state + "&client_id=1fddee4e-b100-4f4e-b2b0-097f9088f9d2&scope=openid+offline";
        System.out.println("Go to this URL, let it do its thing, and bring me back your 'id_token'\n");
        System.out.println(url + "\n");
        MainFrame.openNewTab(url);
    }

    public String getSessionId(String idToken) {
        try {
            String postData = "{\"idToken\":\"" + idToken + "\"}";
            URL url = new URL("https://auth.jagex.com/game-session/v1/sessions");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            try (OutputStream os = con.getOutputStream();){
                byte[] input = postData.getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                JSONObject sessionIdJson = new JSONObject(response.toString());
                System.out.println("Session ID fetched succesfully.");
                return sessionIdJson.getString("sessionId");
            }
            System.out.println("POST request fetching sessionId failed with response code: " + responseCode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public void writeAccountsToTxt(String sessionId) {
        block19: {
            try {
                String apiUrl = "https://auth.jagex.com/game-session/v1/accounts";
                HttpURLConnection connection = (HttpURLConnection)new URL(apiUrl).openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Authorization", "Bearer " + sessionId);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    in.close();
                    Gson gson = new Gson();
                    List newAccounts = (List)gson.fromJson(response.toString(), new TypeToken<List<Account>>(){}.getType());
                    for (Account account2 : newAccounts) {
                        account2.sessionId = sessionId;
                        account2.createdOn = new Date();
                    }
                    String userHome = System.getProperty("user.home");
                    Path directoryPath = Paths.get(userHome, ".microbot");
                    Path filePath = Paths.get(directoryPath.toString(), "accounts.json");
                    File file = new File(filePath.toString());
                    file.createNewFile();
                    List existingAccounts = new ArrayList();
                    if (file.exists()) {
                        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                            existingAccounts = (List)gson.fromJson((Reader)reader, new TypeToken<List<Account>>(){}.getType());
                        }
                    }
                    if (existingAccounts == null) {
                        existingAccounts = new ArrayList();
                    }
                    Set existingAccountIds = existingAccounts.stream().map(Account::getAccountId).collect(Collectors.toSet());
                    List nonDuplicateNewAccounts = newAccounts.stream().filter(account -> !existingAccountIds.contains(account.getAccountId())).collect(Collectors.toList());
                    existingAccounts.addAll(nonDuplicateNewAccounts);
                    try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath.toString()));){
                        gson.toJson(existingAccounts, (Appendable)writer);
                    }
                    System.out.println("Accounts data written to accounts.json");
                    break block19;
                }
                System.out.println("GET request failed with response code: " + responseCode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String generateNonce(int length) {
        String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder nonce = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            nonce.append(characters.charAt(random.nextInt(characters.length())));
        }
        return nonce.toString();
    }

    public static String extractIdTokenFromUrl(String url) {
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            System.out.println("Failed to parse URI");
        }
        String fragment = uri.getFragment();
        if (fragment != null) {
            Map<String, String> params = CustomRequestHandler.splitQuery(fragment);
            return params.get("id_token");
        }
        return null;
    }

    private static Map<String, String> splitQuery(String query) {
        String[] pairs;
        HashMap<String, String> queryPairs = new HashMap<String, String>();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            queryPairs.put(pair.substring(0, idx), pair.substring(idx + 1));
        }
        return queryPairs;
    }

    public static String extractCodeFromUrl(String url) {
        String[] parameters;
        for (String parameter : parameters = url.split(",")) {
            if (!parameter.startsWith("jagex:code=")) continue;
            return parameter.substring(parameter.indexOf(61) + 1);
        }
        return null;
    }

    private String containsQueryParameter(String urlString, String queryKey) {
        if (urlString.contains(queryKey + "=")) {
            return urlString;
        }
        return "";
    }

    public static String readResponse(HttpURLConnection connection) throws IOException {
        StringBuilder response = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
        }
        return response.toString();
    }

    static class Account {
        private String sessionId;
        private String accountId;
        private String displayName;
        private String userHash;
        private Date createdOn;

        Account() {
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getUserHash() {
            return this.userHash;
        }
    }
}

