/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import me.friwi.jcefmaven.CefInitializationException;
import me.friwi.jcefmaven.UnsupportedPlatformException;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.example.CustomRequestHandler;

public class MainFrame {
    public static CefClient client;
    public static JTabbedPane tabbedPane;

    public static void create(String startURL, boolean useOSR, boolean isTransparent, String[] args) throws UnsupportedPlatformException, CefInitializationException, IOException, InterruptedException {
        CefSettings settings = new CefSettings();
        settings.windowless_rendering_enabled = false;
        final CefApp cefApp = CefApp.getInstance(settings);
        client = cefApp.createClient();
        client.addRequestHandler(new CustomRequestHandler());
        String url = startURL;
        CefBrowser browser = client.createBrowser(url, false, false);
        Component browserUI = browser.getUIComponent();
        JFrame frame = new JFrame();
        tabbedPane = new JTabbedPane();
        tabbedPane.add(browserUI, "Login");
        frame.setSize(800, 600);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        frame.getContentPane().add((Component)tabbedPane, "Center");
        client.addLifeSpanHandler(new CefLifeSpanHandlerAdapter(){

            @Override
            public void onBeforeClose(CefBrowser browser) {
                cefApp.dispose();
                System.exit(0);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> cefApp.dispose()));
    }

    public static void openNewTab(final String startURL) {
        if (client == null) {
            System.out.println("Something went wrong! Client is null");
        }
        CefBrowser browser = client.createBrowser(startURL, false, false);
        JPanel browserPanel = new JPanel(new BorderLayout());
        browserPanel.add(browser.getUIComponent(), "Center");
        tabbedPane.addTab("Tab " + (tabbedPane.getTabCount() + 1), browserPanel);
        tabbedPane.setSelectedComponent(browserPanel);
        client.addLifeSpanHandler(new CefLifeSpanHandlerAdapter(){

            @Override
            public void onAfterCreated(CefBrowser browser) {
                super.onAfterCreated(browser);
                System.out.println("New tab created with URL: " + startURL);
            }

            @Override
            public boolean doClose(CefBrowser browser) {
                System.out.println("Tab is closing.");
                return super.doClose(browser);
            }
        });
    }

    public static void main(String[] args) throws UnsupportedPlatformException, CefInitializationException, IOException, InterruptedException {
    }
}

